// Model class, represents a loaded OBJ model
// handles the loading/processing of the model file. Also loads and stores its own texture
// NOT complete, for students to complete. Model data requires being sorted and the render function needs completed.
#ifndef _MODEL_H_
#define _MODEL_H_

// INCLUDES //
#include <glut.h>
#include <fstream>
#include <gl/gl.h>
#include <gl/glu.h>

using namespace std;

// MY CLASS INCLUDES //
#include <vector>
#include <map>
#include <set>
#include <filesystem>
#include "Vector3.h"
#include "Shadow.h"
#include "SOIL.h"

class Model
{
	public:
		//Virtual functions, can be overridden by other models as needed
		virtual bool load(char* modelFilename, char* textureFilename, int renderingShape = GL_TRIANGLES);
		virtual bool loadMTL(char* modelFilename, char* mtlFilename, int renderingShape = GL_TRIANGLES);
		virtual void render(Vector3 position = Vector3(0.0f, 0.0f, 0.0f));

	protected:
		void loadTexture(char*);	//Loads the associated texture for this model
		GLuint loadTextureRet(std::string path);	//Loads a texture and returns the texture variable
		bool loadModel(char*);	//Loads the model obj file
		bool parseMTL(char*);	//Parses the MTL
		void loadAllTextures();	//Loads all the textures required for the model as per the MTL

		//Model/render info
		int m_vertexCount;
		GLuint texture;
		int _RenderingShape;	//Is the model represented in the file as GL_QUADS, GL_TRIANGLES...?
		vector<float> vertex, normals, texCoords;

		vector<string> vertexTextures;	//List of string filenames of textures for each vertex in the model
		std::map<string, GLuint> textures;	//Stores all loaded textures in a map, key is the string filename, value is the GLuint
		std::map<string, string> mtls;

		//Vertices of floor
		GLfloat floorVerts[12] = { 0.0f, 0.05f, -16.0f, //top left
			0.0f, 0.05f, 0.0f, // bottom left
			13.0f, 0.05f, 0.0f,	//bottom right
			13.0f, 0.05f, -16.0f };	//top right

		//Shadow arrays
		float shadowMatrix[16];
		float lightPosition[3];

		bool usingMTL = false;
};

#endif